"use strict";function asyncGeneratorStep(gen,resolve,reject,_next,_throw,key,arg){try{var info=gen[key](arg);var value=info.value}catch(error){reject(error);return}if(info.done){resolve(value)}else{Promise.resolve(value).then(_next,_throw)}}function _asyncToGenerator(fn){return function(){var self=this,args=arguments;return new Promise(function(resolve,reject){var gen=fn.apply(self,args);function _next(value){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"next",value)}function _throw(err){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"throw",err)}_next(undefined)})}}/*global $, jQuery, _, asm, common, config, controller, dlgfx, edit_header, format, header, html, tableform, validate */$(function(){"use strict";var diary={model:function model(){var dialog={add_title:_("Add diary"),edit_title:_("Edit diary"),helper_text:_("Diary notes need a date and subject.")+"<br />"+_("Times should be in HH:MM format, eg: 09:00, 16:30"),close_on_ok:false,columns:1,width:500,fields:[{json_field:"DIARYFORNAME",post_field:"diaryfor",label:_("For"),type:"select",options:{rows:controller.forlist,displayfield:"USERNAME",valuefield:"USERNAME"}},{json_field:"DIARYDATETIME",post_field:"diarydate",label:_("Date"),type:"date",validation:"notblank",defaultval:new Date},{json_field:"DIARYDATETIME",post_field:"diarytime",label:_("Time"),type:"time"},{json_field:"DATECOMPLETED",post_field:"completed",label:_("Completed"),type:"date"},{json_field:"SUBJECT",label:_("Subject"),post_field:"subject",validation:"notblank",type:"text"},{json_field:"NOTE",label:_("Note"),post_field:"note",validation:"notblank",type:"textarea"},{json_field:"COMMENTS",label:_("Comments"),post_field:"comments",type:"textarea"}]};var table={rows:controller.rows,idcolumn:"ID",edit:function edit(row){tableform.fields_populate_from_json(dialog.fields,row);tableform.dialog_show_edit(dialog,row,{onchange:function(){var _onchange=_asyncToGenerator(/*#__PURE__*/regeneratorRuntime.mark(function _callee(){return regeneratorRuntime.wrap(function _callee$(_context){while(1){switch(_context.prev=_context.next){case 0:_context.prev=0;tableform.fields_update_row(dialog.fields,row);_context.next=4;return tableform.fields_post(dialog.fields,"mode=update&diaryid="+row.ID,"diary");case 4:tableform.table_update(table);tableform.dialog_close();_context.next=13;break;case 8:_context.prev=8;_context.t0=_context["catch"](0);log.error(_context.t0,_context.t0);tableform.dialog_error(response);tableform.dialog_enable_buttons();case 13:case"end":return _context.stop();}}},_callee,null,[[0,8]])}));function onchange(){return _onchange.apply(this,arguments)}return onchange}(),onload:function onload(row){// If this is my/all diary notes, and the user does not
// have the edit all diary notes permission and is not
// the person who created the diary note, they should only 
// be able to edit the comments.
if(controller.name.indexOf("diary_edit")==0&&row.CREATEDBY!=asm.user&&!common.has_permission("eadn")){$("#subjecttext").remove();$("#notetext").remove();$("#note").closest("span").hide();$("#subject").hide();$("#note").closest("td").append("<span id='notetext'>"+row.NOTE+"</span>");$("#subject").closest("td").append("<span id='subjecttext'>"+row.SUBJECT+"</span>")}else{$("#subjecttext").remove();$("#notetext").remove();$("#subject").show();$("#note").closest("span").show()}// Allow editing of the comments once the diary is created
$("#comments").closest("tr").show()}})},complete:function complete(row){if(row.DATECOMPLETED){return true}return false},overdue:function overdue(row){return!row.DATECOMPLETED&&format.date_js(row.DIARYDATETIME)<common.today_no_time()},columns:[{field:"DIARYFORNAME",display:_("For")},{field:"DIARYDATETIME",display:_("Date"),formatter:tableform.format_datetime,initialsort:true,initialsortdirection:"desc"},{field:"DATECOMPLETED",display:_("Completed"),formatter:tableform.format_date},{field:"LINKINFO",display:_("Link"),formatter:function formatter(row){var link="#";if(row.LINKTYPE==1){link="animal?id="+row.LINKID}if(row.LINKTYPE==2){link="person?id="+row.LINKID}if(row.LINKTYPE==3){link="lostanimal?id="+row.LINKID}if(row.LINKTYPE==4){link="foundanimal?id="+row.LINKID}if(row.LINKTYPE==5){link="waitinglist?id="+row.LINKID}if(row.LINKTYPE==6){link="incident?id="+row.LINKID}if(link!="#"){return"<a href=\""+link+"\">"+row.LINKINFO+"</a>"}return row.LINKINFO},hideif:function hideif(){return common.current_url().indexOf("diary_edit")==-1}},{field:"SUBJECT",display:_("Subject")},{field:"NOTE",display:_("Note")},{field:"CREATEDBY",display:_("By")}]};var buttons=[{id:"new",text:_("New Diary"),icon:"new",enabled:"always",perm:"adn",click:function click(){diary.new_note()}},{id:"delete",text:_("Delete"),icon:"delete",enabled:"multi",perm:"ddn",click:function(){var _click=_asyncToGenerator(/*#__PURE__*/regeneratorRuntime.mark(function _callee2(){var ids;return regeneratorRuntime.wrap(function _callee2$(_context2){while(1){switch(_context2.prev=_context2.next){case 0:_context2.next=2;return tableform.delete_dialog();case 2:tableform.buttons_default_state(buttons);ids=tableform.table_ids(table);_context2.next=6;return common.ajax_post("diary","mode=delete&ids="+ids);case 6:tableform.table_remove_selected_from_json(table,controller.rows);tableform.table_update(table);case 8:case"end":return _context2.stop();}}},_callee2)}));function click(){return _click.apply(this,arguments)}return click}()},{id:"complete",text:_("Complete"),icon:"complete",enabled:"multi",click:function(){var _click2=_asyncToGenerator(/*#__PURE__*/regeneratorRuntime.mark(function _callee3(){var ids;return regeneratorRuntime.wrap(function _callee3$(_context3){while(1){switch(_context3.prev=_context3.next){case 0:ids=tableform.table_ids(table);_context3.next=3;return common.ajax_post("diary","mode=complete&ids="+ids);case 3:$.each(controller.rows,function(i,v){if(tableform.table_id_selected(v.ID)){v.DATECOMPLETED=format.date_iso(new Date)}});tableform.table_update(table);case 5:case"end":return _context3.stop();}}},_callee3)}));function click(){return _click2.apply(this,arguments)}return click}()},{id:"filter",type:"dropdownfilter",options:["uncompleted|"+_("Incomplete notes upto today"),"completed|"+_("Completed notes upto today"),"all|"+_("All notes upto today"),"future|"+_("Future notes")],hideif:function hideif(){return common.current_url().indexOf("diary_edit")==-1},click:function click(selval){common.route(controller.name+"?filter="+selval)}}];this.dialog=dialog;this.buttons=buttons;this.table=table},set_extra_fields:function set_extra_fields(row){row.CREATEDBY=asm.user},render:function render(){var h=[];this.model();h.push(tableform.dialog_render(this.dialog));if(controller.name=="animal_diary"){h.push(edit_header.animal_edit_header(controller.animal,"diary",controller.tabcounts))}else if(controller.name=="person_diary"){h.push(edit_header.person_edit_header(controller.person,"diary",controller.tabcounts))}else if(controller.name=="waitinglist_diary"){h.push(edit_header.waitinglist_edit_header(controller.animal,"diary",controller.tabcounts))}else if(controller.name=="lostanimal_diary"){h.push(edit_header.lostfound_edit_header("lost",controller.animal,"diary",controller.tabcounts))}else if(controller.name=="foundanimal_diary"){h.push(edit_header.lostfound_edit_header("found",controller.animal,"diary",controller.tabcounts))}else if(controller.name=="incident_diary"){h.push(edit_header.incident_edit_header(controller.incident,"diary",controller.tabcounts))}else if(controller.name=="diary_edit"){h.push(html.content_header(_("Edit diary notes")))}else if(controller.name=="diary_edit_my"){h.push(html.content_header(_("Edit my  diary notes")))}h.push(tableform.buttons_render(this.buttons));h.push(tableform.table_render(this.table));h.push(html.content_footer());return h.join("\n")},bind:function bind(){$(".asm-tabbar").asmtabs();tableform.dialog_bind(this.dialog);tableform.buttons_bind(this.buttons);tableform.table_bind(this.table,this.buttons)},sync:function sync(){// If a filter is given in the querystring, update the select
if(common.current_url().indexOf("filter=")!=-1){var filterurl=common.current_url().substring(common.current_url().indexOf("filter=")+7);$("#filter").select("value",filterurl)}if(controller.newnote){diary.new_note()}},new_note:function new_note(){tableform.dialog_show_add(diary.dialog,{onadd:function(){var _onadd=_asyncToGenerator(/*#__PURE__*/regeneratorRuntime.mark(function _callee4(){var response,row;return regeneratorRuntime.wrap(function _callee4$(_context4){while(1){switch(_context4.prev=_context4.next){case 0:_context4.next=2;return tableform.fields_post(diary.dialog.fields,"mode=create&linktypeid="+controller.linktypeid+"&linkid="+controller.linkid,"diary");case 2:response=_context4.sent;row={};row.ID=response;tableform.fields_update_row(diary.dialog.fields,row);diary.set_extra_fields(row);controller.rows.push(row);tableform.table_update(diary.table);tableform.dialog_close();case 10:case"end":return _context4.stop();}}},_callee4)}));function onadd(){return _onadd.apply(this,arguments)}return onadd}(),onload:function onload(){tableform.dialog_enable_buttons();// Show the note textarea and subject box and remove any old text display of notes
$("#notetext").remove();$("#subjecttext").remove();$("#note").closest("span").show();$("#subject").show();// Hide the comments field for new diary notes
$("#comments").closest("tr").hide();// If a default diary person is set, choose them
if(config.str("AFDefaultDiaryPerson")){$("#diaryfor").select("value",config.str("AFDefaultDiaryPerson"))}}})},destroy:function destroy(){tableform.dialog_destroy()},name:"diary",animation:function animation(){return controller.name.indexOf("diary_edit")==0?"book":"formtab"},title:function title(){var t="";if(controller.name=="animal_diary"){t=common.substitute(_("{0} - {1} ({2} {3} aged {4})"),{0:controller.animal.ANIMALNAME,1:controller.animal.CODE,2:controller.animal.SEXNAME,3:controller.animal.SPECIESNAME,4:controller.animal.ANIMALAGE})}else if(controller.name=="diary_edit"){t=_("Edit diary notes")}else if(controller.name=="diary_edit_my"){t=_("Edit my diary notes")}else if(controller.name=="foundanimal_diary"){t=common.substitute(_("Found animal - {0} {1} [{2}]"),{0:controller.animal.AGEGROUP,1:controller.animal.SPECIESNAME,2:controller.animal.OWNERNAME})}else if(controller.name=="incident_diary"){t=common.substitute(_("Incident {0}, {1}: {2}"),{0:controller.incident.ACID,1:controller.incident.INCIDENTNAME,2:format.date(controller.incident.INCIDENTDATETIME)})}else if(controller.name=="lostanimal_diary"){t=common.substitute(_("Lost animal - {0} {1} [{2}]"),{0:controller.animal.AGEGROUP,1:controller.animal.SPECIESNAME,2:controller.animal.OWNERNAME})}else if(controller.name=="person_diary"){t=controller.person.OWNERNAME}else if(controller.name=="waitinglist_diary"){t=common.substitute(_("Waiting list entry for {0} ({1})"),{0:controller.animal.OWNERNAME,1:controller.animal.SPECIESNAME})}return t},routes:{"animal_diary":function animal_diary(){common.module_loadandstart("diary","animal_diary?id="+this.qs.id)},"diary_edit":function diary_edit(){common.module_loadandstart("diary","diary_edit?"+this.rawqs)},"diary_edit_my":function diary_edit_my(){common.module_loadandstart("diary","diary_edit_my?"+this.rawqs)},"foundanimal_diary":function foundanimal_diary(){common.module_loadandstart("diary","foundanimal_diary?id="+this.qs.id)},"incident_diary":function incident_diary(){common.module_loadandstart("diary","incident_diary?id="+this.qs.id)},"lostanimal_diary":function lostanimal_diary(){common.module_loadandstart("diary","lostanimal_diary?id="+this.qs.id)},"person_diary":function person_diary(){common.module_loadandstart("diary","person_diary?id="+this.qs.id)},"waitinglist_diary":function waitinglist_diary(){common.module_loadandstart("diary","waitinglist_diary?id="+this.qs.id)}}};common.module_register(diary)});