/*global $, console, jQuery */ /*global _, asm, additional, common, config, dlgfx, edit_header, format, html, header, log, validate, escape, unescape */"use strict";/**
 * Person chooser widget. To create one, use a hidden input
 * with a class of asm-personchooser. You can also specify
 * a data-filter attribute to only search certain types of person
 * records.
 *     
 *     filter: One of all, vet, retailer, staff, fosterer, volunteer, shelter, 
 *             aco, homechecked, homechecker, member, donor
 *     mode:   One of full or brief (full shows the address and other info, 
 *             brief just shows the name)
 *
 * <input id="person" data-mode="full" data-filter="vet" class="asm-personchooser" data="boundfield" type="hidden" value="initialid" />
 *
 * callbacks: loaded (after loadbyid is complete)
 *            change (after user has clicked on a new selection)
 *            cleared (after user clicks the clear button)
 */$.widget("asm.personchooser",{selected:null,options:{id:0,rec:{},additionalfields:[],node:null,display:null,dialog:null,dialogadd:null,dialogsimilar:null,towns:"",counties:"",towncounties:"",sites:[],jurisdictions:[],personflags:[],filter:"all",mode:"full",title:_("Find person")},_create:function _create(){var self=this;if(this.element.attr("data-filter")){this.set_filter(this.element.attr("data-filter"))}if(this.element.attr("data-mode")){this.options.mode=this.element.attr("data-mode")}var h=["<div class=\"personchooser\">","<input class=\"personchooser-banned\" type=\"hidden\" value=\"\" />","<input class=\"personchooser-postcode\" type=\"hidden\" value = \"\" />","<input class=\"personchooser-idcheck\" type=\"hidden\" value = \"\" />","<div class=\"personchooser-noperm\" style=\"display: none\">"+_("Forbidden")+"</div>","<table class=\"personchooser-perm\" style=\"margin-left: 0px; margin-right: 0px; width: 100%\">","<tr>","<td class=\"personchooser-display\"></td>","<td valign=\"top\" align=\"right\">","<button class=\"personchooser-link-find\">"+_("Select a person")+"</button>","<button class=\"personchooser-link-new\">"+_("Add a person")+"</button>","<button class=\"personchooser-link-clear\">"+_("Clear")+"</button>","</td>","</tr>","</table>","<div class=\"personchooser-similar\" style=\"display: none\" title=\""+html.title(_("Similar Person"))+"\">","<p><span class=\"ui-icon ui-icon-alert\"></span>",_("This person is very similar to another person on file, carry on creating this record?"),"<br /><br />","<span class=\"similar-person\"></span>","</p>","</div>","<div class=\"personchooser-find\" style=\"display: none\" title=\""+this.options.title+"\">","<input class=\"asm-textbox\" type=\"text\" />","<button>"+_("Search")+"</button>","<img style=\"height: 16px\" src=\"static/images/wait/rolling_3a87cd.svg\" />","<table width=\"100%\">","<thead>","<tr class=\"ui-widget-header\">","<th>"+_("Name")+"</th>","<th>"+_("Code")+"</th>","<th>"+_("Address")+"</th>","<th>"+_("City")+"</th>","<th>"+_("State")+"</th>","<th>"+_("Zipcode")+"</th>",!config.bool("HideCountry")?"<th>"+_("Country")+"</th>":"","</tr>","</thead>","<tbody></tbody>","</table>","</div>","<div class=\"personchooser-add\" style=\"display: none\" title=\""+_("Add person")+"\">","<div class=\"ui-state-highlight ui-corner-all\" style=\"margin-top: 20px; padding: 0 .7em\">","<p><span class=\"ui-icon ui-icon-info\"></span>",_("At least the last name should be completed."),"</p>","</div>","<table width=\"100%\">","<tr>","<td><label>"+_("Class")+"</label></td>","<td><select data=\"ownertype\" class=\"asm-selectbox chooser\">","<option value=\"1\">"+_("Individual/Couple")+"</option>","<option value=\"2\">"+_("Organization")+"</option>","</select></td>","</tr>","<tr class=\"tag-individual\">","<td><label>"+_("Title")+"</label></td>","<td><input class=\"asm-textbox chooser\" data=\"title\" type=\"textbox\" /></td>","</tr>","<tr class=\"tag-individual\">","<td><label>"+_("Initials")+"</label></td>","<td><input class=\"asm-textbox chooser\" maxlength=\"50\" data=\"initials\" type=\"textbox\" /></td>","</tr>","<tr class=\"tag-individual\">","<td><label>"+_("First name(s)")+"</label></td>","<td><input class=\"asm-textbox chooser\" maxlength=\"200\" data=\"forenames\" type=\"textbox\" /></td>","</tr>","<tr>","<td><label class=\"tag-individual\">"+_("Last name")+"</label>","<label class=\"tag-organisation\">"+_("Organization name")+"</label></td>","<td><input class=\"asm-textbox chooser\" maxlength=\"100\" data=\"surname\" type=\"textbox\" /></td>","</tr>","<tr>","<td><label>"+_("Address")+"</label></td>","<td><textarea class=\"asm-textareafixed chooser\" data=\"address\" rows=\"3\"></textarea></td>","</tr>","<tr>","<td><label>"+_("City")+"</label></td>","<td><input class=\"asm-textbox chooser personchooser-town\" maxlength=\"100\" data=\"town\" type=\"textbox\" /></td>","</tr>","<tr>","<td><label>"+_("State")+"</label></td>","<td>",common.iif(config.bool("USStateCodes"),"<select data=\"county\" class=\"asm-selectbox chooser personchooser-county\">"+html.states_us_options(config.str("OrganisationCounty"))+"</select>","<input type=\"text\" data=\"county\" maxlength=\"100\" class=\"asm-textbox chooser personchooser-county\" />"),"</td>","</tr>","<tr>","<td><label>"+_("Zipcode")+"</label></td>","<td><input class=\"asm-textbox chooser\" data=\"postcode\" type=\"textbox\" /></td>","</tr>","<tr class=\"personchooser-countryrow\">","<td><label>"+_("Country")+"</label></td>","<td><input class=\"asm-textbox chooser personchooser-country\" data=\"country\" type=\"textbox\" /></td>","</tr>","<tr>","<td><label>"+_("Home Phone")+"</label></td>","<td><input class=\"asm-textbox asm-phone chooser\" data=\"hometelephone\" type=\"textbox\" /></td>","</tr>","<tr>","<td><label>"+_("Work Phone")+"</label></td>","<td><input class=\"asm-textbox asm-phone chooser\" data=\"worktelephone\" type=\"textbox\" /></td>","</tr>","<tr>","<td><label>"+_("Cell Phone")+"</label></td>","<td><input class=\"asm-textbox asm-phone chooser\" data=\"mobiletelephone\" type=\"textbox\" /></td>","</tr>","<tr>","<td><label>"+_("Email Address")+"</label></td>","<td><input class=\"asm-textbox chooser\" maxlength=\"200\" data=\"emailaddress\" type=\"textbox\" /></td>","</tr>","<tr>","<tr class=\"personchooser-jurisdictionrow\">","<td><label>"+_("Jurisdiction")+"</label></td>","<td>","<select data=\"jurisdiction\" class=\"asm-selectbox chooser personchooser-jurisdiction\">","</select>","</td>","</tr>","<tr>","<td><label>"+_("Flags")+"</label></td>","<td>","<select class=\"personchooser-flags chooser\" data=\"flags\" multiple=\"multiple\">","</select>","</td>","</tr>","<tr class=\"personchooser-gdprrow\">","<td><label>"+_("GDPR Contact Opt-In")+"</label></td>","<td>","<select class=\"personchooser-gdpr chooser\" data=\"gdprcontactoptin\" multiple=\"multiple\">",edit_header.gdpr_contact_options(),"</select>","</td>","</tr>","<tr class=\"personchooser-siterow\">","<td><label>"+_("Site")+"</label></td>","<td>","<select class=\"asm-selectbox chooser personchooser-site\" data=\"site\">","</select>","</td>","</tr>","</table>","</div>","</div>"].join("\n");var node=$(h);this.options.node=node;var dialog=node.find(".personchooser-find");var dialogadd=node.find(".personchooser-add");var dialogsimilar=node.find(".personchooser-similar");this.options.dialog=dialog;this.options.dialogadd=dialogadd;this.options.dialogsimilar=dialogsimilar;this.options.display=node.find(".personchooser-display");this.element.parent().append(node);// Disable based on view person permission
if(!common.has_permission("vo")){node.find(".personchooser-perm").hide();node.find(".personchooser-noperm").show()}// Hide sites for non-multi-site
if(!config.bool("MultiSiteEnabled")){dialogadd.find(".personchooser-siterow").hide()}// Hide jurisdictions for no animal control
if(config.bool("DisableAnimalControl")){dialogadd.find(".personchooser-jurisdictionrow").hide()}// Hide country if option set
if(config.bool("HideCountry")){dialogadd.find(".personchooser-countryrow").hide()}// Hide GDPR if option not on
if(!config.bool("ShowGDPRContactOptIn")){dialogadd.find(".personchooser-gdprrow").hide()}// Create the find dialog
var pcbuttons={};pcbuttons[_("Cancel")]=function(){$(this).dialog("close")};dialog.dialog({autoOpen:false,height:400,width:800,modal:true,dialogClass:"dialogshadow",show:dlgfx.edit_show,hide:dlgfx.edit_hide,buttons:pcbuttons});dialog.find("table").table({sticky_header:false});dialog.find("input").keydown(function(event){if(event.keyCode==13){self.find();return false}});dialog.find("button").button().click(function(){self.find()});dialog.find("img").hide();// Create the add dialog
var check_org=function check_org(){// If it's an organisation, only show the org fields,
// otherwise show individual
if(dialogadd.find("[data='ownertype']").val()==2){dialogadd.find(".tag-organisation").fadeIn();dialogadd.find(".tag-individual").fadeOut()}else{dialogadd.find(".tag-organisation").fadeOut();dialogadd.find(".tag-individual").fadeIn()}};dialogadd.find("[data='ownertype']").change(check_org);var pcaddbuttons={};pcaddbuttons[_("Create this person")]=function(){var valid=true,dialogadd=self.options.dialogadd;// Validate fields that can't be blank
dialogadd.find("label").removeClass(validate.ERROR_LABEL_CLASS);dialogadd.find("input[data='surname']").each(function(){if(common.trim($(this).val())==""){$(this).parent().parent().find("label").addClass(validate.ERROR_LABEL_CLASS);$(this).focus();valid=false;return false}});if(!valid){return}if(!additional.validate_mandatory_node(dialogadd)){return}// Disable the dialog buttons before we make any ajax requests
dialogadd.disable_dialog_buttons();// check for similar people
self.check_similar()};pcaddbuttons[_("Cancel")]=function(){$(this).dialog("close")};dialogadd.dialog({autoOpen:false,width:400,modal:true,dialogClass:"dialogshadow",show:dlgfx.add_show,hide:dlgfx.add_hide,buttons:pcaddbuttons,open:function open(){check_org();// If we're in multi site mode, use the active user's site
if(config.bool("MultiSiteEnabled")){dialogadd.find(".personchooser-site").select("value",asm.siteid)}// Default the country
dialogadd.find(".personchooser-country").val(config.str("OrganisationCountry"));// Default the jurisdiction
dialogadd.find(".personchooser-jurisdiction").select("value",config.str("DefaultJurisdiction"));// If we have a filter, set the appropriate person flags to match
if(self.options.filter){dialogadd.find(".personchooser-flags option[value='"+self.options.filter+"']").prop("selected",true);dialogadd.find(".personchooser-flags").change()}},close:function close(){dialogadd.find("input, textarea").val("");dialogadd.find(".personchooser-flags option:selected").removeAttr("selected");dialogadd.find(".personchooser-flags").change();dialogadd.find(".personchooser-gdpr option:selected").removeAttr("selected");dialogadd.find(".personchooser-gdpr").change();dialogadd.find("label").removeClass(validate.ERROR_LABEL_CLASS);dialogadd.enable_dialog_buttons()}});node.find(".personchooser-link-find").button({icons:{primary:"ui-icon-search"},text:false}).click(function(){dialog.dialog("open")});node.find(".personchooser-link-new").button({icons:{primary:"ui-icon-plus"},text:false}).click(function(){dialogadd.dialog("open")});node.find(".personchooser-link-clear").button({icons:{primary:"ui-icon-trash"},text:false}).click(function(){self.clear(true)});/// Go to the backend to get the additional fields, towns, counties and person flags with lookup data
$.ajax({type:"GET",url:"person_embed",cache:true,// this data can be cached for a few minutes
data:{mode:"lookup"},dataType:"text",success:function success(data,textStatus,jqXHR){var h="";var d=jQuery.parseJSON(data);self.options.additionalfields=d.additional;self.options.towns=d.towns;self.options.counties=d.counties;self.options.towncounties=d.towncounties;self.options.personflags=d.flags;self.options.sites=d.sites;self.options.jurisdictions=d.jurisdictions;// Add person flag options to the screen
html.person_flag_options(null,self.options.personflags,dialogadd.find(".personchooser-flags"));// Setup autocomplete widgets with the towns/counties
dialogadd.find(".personchooser-town").autocomplete({source:self.options.towns});if(!config.bool("USStateCodes")){dialogadd.find(".personchooser-county").autocomplete({source:self.options.counties})}// When the user changes a town, suggest a county if it's blank
dialogadd.find(".personchooser-town").blur(function(){if(dialogadd.find(".personchooser-county").val()==""){dialogadd.find(".personchooser-county").val(self.options.towncounties[dialogadd.find(".personchooser-town").val()])}});// Setup person flag select widget
dialogadd.find(".personchooser-flags").attr("title",_("Select"));dialogadd.find(".personchooser-flags").asmSelect({animate:true,sortable:true,removeLabel:"<strong>X</strong>",listClass:"bsmList-custom",listItemClass:"bsmListItem-custom",listItemLabelClass:"bsmListItemLabel-custom",removeClass:"bsmListItemRemove-custom"});// Setup GDPR select widget
dialogadd.find(".personchooser-gdpr").attr("title",_("Select"));dialogadd.find(".personchooser-gdpr").asmSelect({animate:true,sortable:true,removeLabel:"<strong>X</strong>",listClass:"bsmList-custom",listItemClass:"bsmListItem-custom",listItemLabelClass:"bsmListItemLabel-custom",removeClass:"bsmListItemRemove-custom"});// Add sites
dialogadd.find(".personchooser-site").html("<option value=\"0\">"+_("(all)")+"</option>"+html.list_to_options(self.options.sites,"ID","SITENAME"));// Add jurisdictions
dialogadd.find(".personchooser-jurisdiction").html(html.list_to_options(self.options.jurisdictions,"ID","JURISDICTIONNAME"));dialogadd.find(".personchooser-jurisdiction").select("value",config.str("DefaultJurisdiction"));dialogadd.find(".personchooser-jurisdiction").select("removeRetiredOptions","all");// Add new additional fields
dialogadd.find("table").append(additional.additional_new_fields(d.additional,false,"additional chooser"));// Was there a value already set by the markup? If so, use it
if(self.element.val()!=""&&self.element.val()!="0"){self.loadbyid(self.element.val())}},error:function error(jqxhr,textstatus,response){log.error(response)}})},destroy:function destroy(){try{this.options.dialog.dialog("destroy")}catch(ex){}try{this.options.dialogadd.dialog("destroy")}catch(exa){}try{this.options.dialogsimilar.dialog("destroy")}catch(exs){}},/**
     * Load a person record from its ID
     */loadbyid:function loadbyid(personid){if(!personid||personid=="0"||personid==""){return}this.clear();this.element.val(personid);var self=this,node=this.options.node,display=this.options.display,dialog=this.options.dialog;var formdata="mode=id&id="+personid;$.ajax({type:"POST",url:"person_embed",data:formdata,dataType:"text",success:function success(data,textStatus,jqXHR){var h="";var people=jQuery.parseJSON(data);var rec=people[0];self.element.val(rec.ID);var disp="<span class=\"justlink\"><a class=\"asm-embed-name\" href=\"person?id="+rec.ID+"\">"+rec.OWNERNAME+" - "+rec.OWNERCODE+"</a></span>";if(self.options.mode=="full"){disp+="<br/>"+rec.OWNERADDRESS+"<br/>"+rec.OWNERTOWN+"<br/>"+rec.OWNERCOUNTY+"<br/>"+rec.OWNERPOSTCODE+(!config.bool("HideCountry")?"<br/>"+rec.OWNERCOUNTRY:"")+"<br/>"+rec.HOMETELEPHONE+"<br/>"+rec.WORKTELEPHONE+"<br/>"+rec.MOBILETELEPHONE+"<br/>"+rec.EMAILADDRESS}display.html(disp);node.find(".personchooser-banned").val(rec.ISBANNED);node.find(".personchooser-idcheck").val(rec.IDCHECK);node.find(".personchooser-postcode").val(rec.OWNERPOSTCODE);common.inject_target();self._trigger("loaded",null,rec);self.selected=rec},error:function error(jqxhr,textstatus,response){log.error(response)}})},/**
     * Does the backend find and updates the onscreen table
     * in the find dialog
     */find:function find(){var self=this,dialog=this.options.dialog,node=this.options.node,display=this.options.display;dialog.find("img").show();dialog.find("button").button("disable");var q=encodeURIComponent(dialog.find("input").val());var filter=this.options.filter;var formdata="mode=find&filter="+filter+"&q="+q;$.ajax({type:"POST",url:"person_embed",data:formdata,dataType:"text",success:function success(data,textStatus,jqXHR){var h="";var people=jQuery.parseJSON(data);$.each(people,function(i,p){h+="<tr>";h+="<td><a href=\"#\" data=\""+i+"\">"+p.OWNERNAME+"</a></td>";h+="<td>"+p.OWNERCODE+"</td>";h+="<td>"+p.OWNERADDRESS+"</td>";h+="<td>"+p.OWNERTOWN+"</td>";h+="<td>"+p.OWNERCOUNTY+"</td>";h+="<td>"+p.OWNERPOSTCODE+"</td>";if(!config.bool("HideCountry")){h+="<td>"+p.OWNERCOUNTRY+"</td>"}h+="</tr>"});dialog.find("table > tbody").html(h);// Remove any existing events from previous searches
dialog.off("click","a");// Use delegation to bind click events for 
// the person once clicked. Triggers the change callback
dialog.on("click","a",function(e){var rec=people[$(this).attr("data")];self.element.val(rec.ID);self.options.rec=rec;var disp="<span class=\"justlink\"><a class=\"asm-embed-name\" href=\"person?id="+rec.ID+"\">"+rec.OWNERNAME+" - "+rec.OWNERCODE+"</a></span>";if(self.options.mode=="full"){disp+="<br/>"+rec.OWNERADDRESS+"<br/>"+rec.OWNERTOWN+"<br/>"+rec.OWNERCOUNTY+"<br/>"+rec.OWNERPOSTCODE+(!config.bool("HideCountry")?"<br/>"+rec.OWNERCOUNTRY:"")+"<br/>"+rec.HOMETELEPHONE+"<br/>"+rec.WORKTELEPHONE+"<br/>"+rec.MOBILETELEPHONE+"<br/>"+rec.EMAILADDRESS}display.html(disp);node.find(".personchooser-banned").val(rec.ISBANNED);node.find(".personchooser-idcheck").val(rec.IDCHECK);node.find(".personchooser-postcode").val(rec.OWNERPOSTCODE);try{validate.dirty(true)}catch(exp){}dialog.dialog("close");self._trigger("change",null,rec);self.selected=rec;return false});dialog.find("table").trigger("update");dialog.find("img").hide();dialog.find("button").button("enable");common.inject_target()},error:function error(jqxhr,textstatus,response){dialog.dialog("close");dialog.find("img").hide();dialog.find("button").button("enable");log.error(response)}})},/**
     * Posts the add dialog to the backend to create the owner
     */add_person:function add_person(){var self=this,dialogadd=this.options.dialogadd,dialogsimilar=this.options.dialogsimilar,display=this.options.display,node=this.options.node;var formdata="mode=add&"+dialogadd.find("input, textarea, select").toPOST();$.ajax({type:"POST",url:"person_embed",data:formdata,dataType:"text",success:function success(result){var people=jQuery.parseJSON(result);var rec=people[0];self.element.val(rec.ID);self.selected=rec;var disp="<span class=\"justlink\"><a class=\"asm-embed-name\" href=\"person?id="+rec.ID+"\">"+rec.OWNERNAME+"</a></span>";if(self.options.mode=="full"){disp+="<br/>"+rec.OWNERADDRESS+"<br/>"+rec.OWNERTOWN+"<br/>"+rec.OWNERCOUNTY+"<br/>"+rec.OWNERPOSTCODE+(!config.bool("HideCountry")?"<br/>"+rec.OWNERCOUNTRY:"")+"<br/>"+rec.HOMETELEPHONE+"<br/>"+rec.WORKTELEPHONE+"<br/>"+rec.MOBILETELEPHONE+"<br/>"+rec.EMAILADDRESS}display.html(disp);node.find(".personchooser-banned").val(rec.ISBANNED);node.find(".personchooser-idcheck").val(rec.IDCHECK);node.find(".personchooser-postcode").val(rec.OWNERPOSTCODE);try{validate.dirty(true)}catch(ev){}dialogadd.dialog("close");common.inject_target();try{dialogsimilar.dialog("close")}catch(es){}self._trigger("change",null,rec)},error:function error(jqxhr,textstatus,response){dialogadd.dialog("close");log.error(response)}})},/**
     * Pops up the similar dialog box to prompt the user to decide
     * whether they want to create the owner or not. If they do,
     * calls add_person to do the adding.
     */show_similar:function show_similar(){var b={},self=this,dialogsimilar=this.options.dialogsimilar,dialogadd=this.options.dialogadd;b[_("Create")]=function(){dialogsimilar.disable_dialog_buttons();self.add_person();dialogsimilar.close();dialogadd.close()};b[_("Cancel")]=function(){$(this).dialog("close");dialogadd.enable_dialog_buttons()};dialogsimilar.dialog({resizable:false,modal:true,width:500,dialogClass:"dialogshadow",show:dlgfx.delete_show,hide:dlgfx.delete_hide,buttons:b,close:function close(){dialogsimilar.enable_dialog_buttons()}})},/**
     * Checks to see whether we have a similar person
     * on file. If we do, calls show_siilar to popup the
     * confirmation dialog
     */check_similar:function check_similar(){var self=this,dialogadd=this.options.dialogadd,dialogsimilar=this.options.dialogsimilar;var formdata="mode=similar&"+dialogadd.find("input[data='emailaddress'], input[data='mobiletelephone'], input[data='surname'], input[data='forenames'], input[data='address']").toPOST();$.ajax({type:"POST",url:"person_embed",data:formdata,dataType:"text",success:function success(result){var people=jQuery.parseJSON(result);var rec=people[0];if(rec===undefined){self.add_person()}else{var disp="<span class=\"justlink\"><a class=\"asm-embed-name\" href=\"#\">"+rec.OWNERNAME+"</a></span>";if(self.options.mode=="full"){disp+="<br/>"+rec.OWNERADDRESS+"<br/>"+rec.OWNERTOWN+"<br/>"+rec.OWNERCOUNTY+"<br/>"+rec.OWNERPOSTCODE+(!config.bool("HideCountry")?"<br/>"+rec.OWNERCOUNTRY:"")+"<br/>"+rec.HOMETELEPHONE+"<br/>"+rec.WORKTELEPHONE+"<br/>"+rec.MOBILETELEPHONE+"<br/>"+rec.EMAILADDRESS}dialogsimilar.find(".similar-person").html(disp);// When the user clicks the name of the similar person,
// select it for the field instead
dialogsimilar.find(".asm-embed-name").click(function(){self.loadbyid(rec.ID);dialogsimilar.dialog("close");dialogadd.dialog("close");return false});self.show_similar()}},error:function error(jqxhr,textstatus,response){log.error(response)}})},clear:function clear(fireclearedevent){this.element.val("0");this.options.id=0;this.options.display.html("");this.selected=null;if(fireclearedevent){this._trigger("cleared",null)}},is_empty:function is_empty(){return this.selected==null},/**
     * Returns the selected person record. If there's nothing
     * selected, undefined/null is returned
     */get_selected:function get_selected(){return this.selected},/**
     * Changes the find filter to f.
     */set_filter:function set_filter(f){var title="";this.options.filter=f;// Choose the title from the filter
if(f=="vet"){title=_("Find vet")}else if(f=="retailer"){title=_("Find retailer")}else if(f=="staff"){title=_("Find staff")}else if(f=="fosterer"){title=_("Find fosterer")}else if(f=="volunteer"){title=_("Find volunteer")}else if(f=="volunteerandstaff"){title=_("Find staff/volunteer")}else if(f=="shelter"){title=_("Find shelter")}else if(f=="aco"){title=_("Find aco")}else if(f=="homechecked"){title=_("Find homechecked")}else if(f=="homechecker"){title=_("Find homechecker")}else if(f=="member"){title=_("Find member")}else if(f=="donor"){title=_("Find donor")}else if(f=="driver"){title=_("Find driver")}else{title=_("Find person")}this.options.title=title;if(this.options.dialog){this.options.dialog.dialog("option","title",title)}}});